#!/bin/bash
export datasets1="Cora CiteSeer PubMed OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=1

for missing_rate in 0.99 0.999 0.9999
do
for ver in 5
do
for epoch_start in 0 1 2 3 4 5 6 7 8 9
do
python main.py --dataset physics --missing_type uniform --missing_rate ${missing_rate} --embedder GOODIE_best --ver ${ver} --epoch_start ${epoch_start} --n_runs 1 --gpu ${gpu}
done
done
done